/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.user;

import com.floragunn.searchguard.user.User;

public class AuthDomainInfo {
    public static AuthDomainInfo UNKNOWN = new AuthDomainInfo(null, null, null);
    public static AuthDomainInfo ANON = AuthDomainInfo.forAuthenticatorType("none");
    public static AuthDomainInfo TLS_CERT = AuthDomainInfo.forAuthenticatorType("tls_cert");
    public static AuthDomainInfo IMPERSONATION_TLS = AuthDomainInfo.forAuthenticatorType("impersonation+tls_cert");
    public static AuthDomainInfo STORED_AUTH = AuthDomainInfo.forAuthenticatorType("stored_auth");
    private final String authDomainId;
    private final String authenticatorType;
    private final String authBackendType;

    private AuthDomainInfo(String authDomainId, String authenticatorType, String authBackendType) {
        this.authDomainId = authDomainId;
        this.authBackendType = authBackendType;
        this.authenticatorType = authenticatorType;
    }

    public String getAuthDomainId() {
        return this.authDomainId;
    }

    public AuthDomainInfo authDomainId(String authDomainId) {
        return new AuthDomainInfo(authDomainId, this.authenticatorType, this.authBackendType);
    }

    public String getAuthenticatorType() {
        return this.authenticatorType;
    }

    public AuthDomainInfo authenticatorType(String authenticatorType) {
        return new AuthDomainInfo(this.authDomainId, authenticatorType, this.authBackendType);
    }

    public String getAuthBackendType() {
        return this.authBackendType;
    }

    public AuthDomainInfo authBackendType(String authBackendType) {
        return new AuthDomainInfo(this.authDomainId, this.authenticatorType, authBackendType);
    }

    public AuthDomainInfo addAuthBackend(String authBackendType) {
        String newAuthBackendType = this.authBackendType;
        newAuthBackendType = newAuthBackendType == null ? authBackendType : authBackendType + "+" + newAuthBackendType;
        return new AuthDomainInfo(this.authDomainId, this.authenticatorType, newAuthBackendType);
    }

    public AuthDomainInfo add(AuthDomainInfo other) {
        if (other == null || other.authDomainId == null && other.authBackendType == null && other.authenticatorType == null) {
            return this;
        }
        return new AuthDomainInfo(other.authDomainId != null ? other.authDomainId : this.authDomainId, other.authenticatorType != null ? other.authenticatorType : this.authenticatorType, other.authBackendType != null ? other.authBackendType : this.authBackendType);
    }

    public boolean isUnknown() {
        return this.authenticatorType == null && this.authBackendType == null && this.authDomainId != null;
    }

    public static AuthDomainInfo forAuthDomainId(String authDomainId) {
        return new AuthDomainInfo(authDomainId, null, null);
    }

    public static AuthDomainInfo forAuthenticatorType(String authenticatorType) {
        return new AuthDomainInfo(null, authenticatorType, null);
    }

    public String toString() {
        return "AuthDomainInfo [authDomainId=" + this.authDomainId + ", authenticatorType=" + this.authenticatorType + ", authBackendType=" + this.authBackendType + "]";
    }

    public String toInfoString() {
        if (this.authenticatorType != null && this.authBackendType != null) {
            return this.authenticatorType + "/" + this.authBackendType;
        }
        if (this.authenticatorType != null) {
            return this.authenticatorType;
        }
        if (this.authBackendType != null) {
            return "/" + this.authBackendType;
        }
        return "n/a";
    }

    public static AuthDomainInfo from(User user) {
        String string = user.getAuthDomain();
        if (string == null || string.equals("n/a")) {
            return UNKNOWN;
        }
        int slash = string.indexOf(47);
        if (slash == -1) {
            return AuthDomainInfo.forAuthenticatorType(string);
        }
        if (slash == 0) {
            return new AuthDomainInfo(null, null, string.substring(1));
        }
        return new AuthDomainInfo(null, string.substring(0, slash), string.substring(slash + 1));
    }
}

